/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.track;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackMaterialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class TrackRenderer
implements class_827<TrackBlockEntity, TrackRenderState> {
    public TrackRenderer(class_5614.class_5615 context) {
    }

    public TrackRenderState createRenderState() {
        return new TrackRenderState();
    }

    public void extractRenderState(TrackBlockEntity be, TrackRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_1937 world = be.method_10997();
        if (VisualizationManager.supportsVisualization((class_1936)world)) {
            return;
        }
        GirderRenderState girder = null;
        IdentityHashMap<TrackMaterial, TrackSegmentRenderState> tracks = null;
        for (BezierConnection bc : be.getConnections().values()) {
            int length;
            Object segment;
            if (!bc.isPrimary()) continue;
            class_2338 bePosition = (class_2338)bc.bePositions.getFirst();
            if (bc.hasGirder) {
                segment = bc.getBakedGirders(GirderAngles::new);
                length = ((GirderAngles)segment).length;
                if (length > 1) {
                    if (girder == null) {
                        girder = GirderRenderState.create();
                    }
                    for (int i = 1; i < length; ++i) {
                        girder.add(class_761.method_23794((class_1920)world, (class_2338)((GirderAngles)segment).lightPosition[i].method_10081((class_2382)bePosition)), ((GirderAngles)segment).beams[i], ((GirderAngles)segment).beamCaps[i]);
                    }
                }
            }
            segment = bc.getBakedSegments(SegmentAngles::new);
            length = ((SegmentAngles)segment).length;
            if (length <= 1) continue;
            if (tracks == null) {
                tracks = new IdentityHashMap<TrackMaterial, TrackSegmentRenderState>();
            }
            TrackSegmentRenderState renderState = tracks.computeIfAbsent(bc.getMaterial(), TrackSegmentRenderState::create);
            for (int i = 1; i < length; ++i) {
                renderState.add(class_761.method_23794((class_1920)world, (class_2338)((SegmentAngles)segment).lightPosition[i].method_10081((class_2382)bePosition)), ((SegmentAngles)segment).tieTransform[i], ((SegmentAngles)segment).railTransforms[i]);
            }
        }
        if (tracks == null && girder == null) {
            return;
        }
        state.field_62673 = be.method_11016();
        state.field_62675 = be.method_11017();
        state.layer = class_12249.method_75972();
        state.girder = girder;
        state.tracks = tracks;
    }

    public void submit(TrackRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, (class_11659.class_11660)state);
    }

    public boolean method_3563() {
        return true;
    }

    public int method_33893() {
        return 192;
    }

    public static class_243 getModelAngles(class_243 normal, class_243 diff) {
        double diffX = diff.method_10216();
        double diffY = diff.method_10214();
        double diffZ = diff.method_10215();
        double len = class_3532.method_15355((float)((float)(diffX * diffX + diffZ * diffZ)));
        double yaw = class_3532.method_15349((double)diffX, (double)diffZ);
        double pitch = class_3532.method_15349((double)len, (double)diffY) - 1.5707963267948966;
        class_243 yawPitchNormal = VecHelper.rotate(VecHelper.rotate(new class_243(0.0, 1.0, 0.0), AngleHelper.deg(pitch), class_2350.class_2351.field_11048), AngleHelper.deg(yaw), class_2350.class_2351.field_11052);
        double signum = Math.signum(yawPitchNormal.method_1026(normal));
        if (Math.abs(signum) < 0.5) {
            signum = yawPitchNormal.method_1025(normal) < 0.5 ? -1.0 : 1.0;
        }
        double dot = diff.method_1036(normal).method_1029().method_1026(yawPitchNormal);
        double roll = Math.acos(class_3532.method_15350((double)dot, (double)-1.0, (double)1.0)) * signum;
        return new class_243(pitch, yaw, roll);
    }

    @Environment(value=EnvType.CLIENT)
    public static class TrackRenderState
    extends class_11954
    implements class_11659.class_11660 {
        public class_1921 layer;
        public GirderRenderState girder;
        public Map<TrackMaterial, TrackSegmentRenderState> tracks;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (this.girder != null) {
                this.girder.render(matricesEntry, vertexConsumer);
            }
            if (this.tracks != null) {
                for (TrackSegmentRenderState track : this.tracks.values()) {
                    track.render(matricesEntry, vertexConsumer);
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class GirderAngles {
        public final int length;
        public final Couple<class_4587.class_4665>[] beams;
        public final Couple<Couple<class_4587.class_4665>>[] beamCaps;
        public final class_2338[] lightPosition;

        GirderAngles(BezierConnection bc) {
            int segmentCount = bc.getSegmentCount();
            this.length = segmentCount + 1;
            this.beams = new Couple[this.length];
            this.beamCaps = new Couple[this.length];
            this.lightPosition = new class_2338[this.length];
            Couple<Couple<class_243>> previousOffsets = null;
            for (BezierConnection.Segment segment : bc) {
                int i = segment.index;
                boolean end = i == 0 || i == segmentCount;
                class_243 leftGirder = segment.position.method_1019(segment.normal.method_1021((double)0.965f));
                class_243 rightGirder = segment.position.method_1020(segment.normal.method_1021((double)0.965f));
                class_243 upNormal = segment.derivative.method_1029().method_1036(segment.normal);
                class_243 firstGirderOffset = upNormal.method_1021(-0.5);
                class_243 secondGirderOffset = upNormal.method_1021(-0.625);
                class_243 leftTop = segment.position.method_1019(segment.normal.method_1021(1.0)).method_1019(firstGirderOffset);
                class_243 rightTop = segment.position.method_1020(segment.normal.method_1021(1.0)).method_1019(firstGirderOffset);
                class_243 leftBottom = leftTop.method_1019(secondGirderOffset);
                class_243 rightBottom = rightTop.method_1019(secondGirderOffset);
                this.lightPosition[i] = class_2338.method_49638((class_2374)leftGirder.method_1019(rightGirder).method_1021(0.5));
                Couple<Couple<class_243>> offsets = Couple.create(Couple.create(leftTop, rightTop), Couple.create(leftBottom, rightBottom));
                if (previousOffsets == null) {
                    previousOffsets = offsets;
                    continue;
                }
                this.beams[i] = Couple.create(null, null);
                this.beamCaps[i] = Couple.create(Couple.create(null, null), Couple.create(null, null));
                float scale = end ? 2.3f : 2.2f;
                for (boolean first : Iterate.trueAndFalse) {
                    class_243 currentBeam = ((class_243)((Couple)offsets.getFirst()).get(first)).method_1019((class_243)((Couple)offsets.getSecond()).get(first)).method_1021(0.5);
                    class_243 previousBeam = ((class_243)((Couple)previousOffsets.getFirst()).get(first)).method_1019((class_243)((Couple)previousOffsets.getSecond()).get(first)).method_1021(0.5);
                    class_243 beamDiff = currentBeam.method_1020(previousBeam);
                    class_243 beamAngles = TrackRenderer.getModelAngles(segment.normal, beamDiff);
                    class_4587 poseStack = new class_4587();
                    ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(poseStack).translate(previousBeam)).rotateY((float)beamAngles.field_1351)).rotateX((float)beamAngles.field_1352)).rotateZ((float)beamAngles.field_1350)).translate(0.0f, 0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f, -0.03125f).scale(1.0f, 1.0f, (float)beamDiff.method_1033() * scale);
                    this.beams[i].set(first, poseStack.method_23760());
                    for (boolean top : Iterate.trueAndFalse) {
                        class_243 current = offsets.get(top).get(first);
                        class_243 previous = previousOffsets.get(top).get(first);
                        class_243 diff = current.method_1020(previous);
                        class_243 capAngles = TrackRenderer.getModelAngles(segment.normal, diff);
                        poseStack = new class_4587();
                        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(poseStack).translate(previous)).rotateY((float)capAngles.field_1351)).rotateX((float)capAngles.field_1352)).rotateZ((float)capAngles.field_1350)).translate(0.0f, 0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f, -0.03125f).rotateZ(0.0f)).scale(1.0f, 1.0f, (float)diff.method_1033() * scale);
                        this.beamCaps[i].get(top).set(first, poseStack.method_23760());
                    }
                }
                previousOffsets = offsets;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record GirderRenderState(SuperByteBuffer girderMiddle, SuperByteBuffer girderTop, SuperByteBuffer girderBottom, List<GirderSegmentData> girders) {
        public static GirderRenderState create() {
            class_2680 air = class_2246.field_10124.method_9564();
            SuperByteBuffer middle = CachedBuffers.partial(AllPartialModels.GIRDER_SEGMENT_MIDDLE, air);
            SuperByteBuffer top = CachedBuffers.partial(AllPartialModels.GIRDER_SEGMENT_TOP, air);
            SuperByteBuffer bottom = CachedBuffers.partial(AllPartialModels.GIRDER_SEGMENT_BOTTOM, air);
            return new GirderRenderState(middle, top, bottom, new ArrayList<GirderSegmentData>());
        }

        public void add(int light, Couple<class_4587.class_4665> beam, Couple<Couple<class_4587.class_4665>> beamCap) {
            this.girders.add(new GirderSegmentData(light, beam, beamCap));
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (GirderSegmentData girder : this.girders) {
                for (boolean first : Iterate.trueAndFalse) {
                    class_4587.class_4665 beamTransform = girder.beam.get(first);
                    ((SuperByteBuffer)((SuperByteBuffer)this.girderMiddle.mulPose((Matrix4fc)beamTransform.method_23761())).mulNormal((Matrix3fc)beamTransform.method_23762())).light(girder.light).renderInto(matricesEntry, vertexConsumer);
                    for (boolean top : Iterate.trueAndFalse) {
                        class_4587.class_4665 beamCapTransform = girder.beamCaps.get(top).get(first);
                        ((SuperByteBuffer)((SuperByteBuffer)(top ? this.girderTop : this.girderBottom).mulPose((Matrix4fc)beamCapTransform.method_23761())).mulNormal((Matrix3fc)beamCapTransform.method_23762())).light(girder.light).renderInto(matricesEntry, vertexConsumer);
                    }
                }
            }
        }

        @Environment(value=EnvType.CLIENT)
        public record GirderSegmentData(int light, Couple<class_4587.class_4665> beam, Couple<Couple<class_4587.class_4665>> beamCaps) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class SegmentAngles {
        public final int length;
        @NotNull
        public final class_4587.class_4665[] tieTransform;
        @NotNull
        public final Couple<class_4587.class_4665>[] railTransforms;
        @NotNull
        public final class_2338[] lightPosition;

        SegmentAngles(BezierConnection bc) {
            int segmentCount = bc.getSegmentCount();
            this.length = segmentCount + 1;
            this.tieTransform = new class_4587.class_4665[segmentCount + 1];
            this.railTransforms = new Couple[segmentCount + 1];
            this.lightPosition = new class_2338[segmentCount + 1];
            Couple<class_243> previousOffsets = null;
            for (BezierConnection.Segment segment : bc) {
                int i = segment.index;
                boolean end = i == 0 || i == segmentCount;
                Couple<class_243> railOffsets = Couple.create(segment.position.method_1019(segment.normal.method_1021((double)0.965f)), segment.position.method_1020(segment.normal.method_1021((double)0.965f)));
                class_243 railMiddle = ((class_243)railOffsets.getFirst()).method_1019((class_243)railOffsets.getSecond()).method_1021(0.5);
                if (previousOffsets == null) {
                    previousOffsets = railOffsets;
                    continue;
                }
                class_243 prevMiddle = ((class_243)previousOffsets.getFirst()).method_1019((class_243)previousOffsets.getSecond()).method_1021(0.5);
                class_243 tieAngles = TrackRenderer.getModelAngles(segment.normal, railMiddle.method_1020(prevMiddle));
                this.lightPosition[i] = class_2338.method_49638((class_2374)railMiddle);
                this.railTransforms[i] = Couple.create(null, null);
                class_4587 poseStack = new class_4587();
                ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(poseStack).translate(prevMiddle)).rotateY((float)tieAngles.field_1351)).rotateX((float)tieAngles.field_1352)).rotateZ((float)tieAngles.field_1350)).translate(-0.5f, -0.12890625f, 0.0f);
                this.tieTransform[i] = poseStack.method_23760();
                float scale = end ? 2.2f : 2.1f;
                for (boolean first : Iterate.trueAndFalse) {
                    class_243 railI = railOffsets.get(first);
                    class_243 prevI = previousOffsets.get(first);
                    class_243 diff = railI.method_1020(prevI);
                    class_243 anglesI = TrackRenderer.getModelAngles(segment.normal, diff);
                    poseStack = new class_4587();
                    ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(poseStack).translate(prevI)).rotateY((float)anglesI.field_1351)).rotateX((float)anglesI.field_1352)).rotateZ((float)anglesI.field_1350)).translate(0.0f, -0.12890625f, -0.03125f).scale(1.0f, 1.0f, (float)diff.method_1033() * scale);
                    this.railTransforms[i].set(first, poseStack.method_23760());
                }
                previousOffsets = railOffsets;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record TrackSegmentRenderState(SuperByteBuffer tie, SuperByteBuffer left, SuperByteBuffer right, List<TrackSegmentData> tracks) {
        public static TrackSegmentRenderState create(TrackMaterial material) {
            AllTrackMaterialModels.TrackModelHolder modelHolder = (AllTrackMaterialModels.TrackModelHolder)material.getModelHolder();
            class_2680 air = class_2246.field_10124.method_9564();
            SuperByteBuffer tie = CachedBuffers.partial(modelHolder.tie(), air);
            SuperByteBuffer left = CachedBuffers.partial(modelHolder.leftSegment(), air);
            SuperByteBuffer right = CachedBuffers.partial(modelHolder.rightSegment(), air);
            return new TrackSegmentRenderState(tie, left, right, new ArrayList<TrackSegmentData>());
        }

        public void add(int light, class_4587.class_4665 tieTransform, Couple<class_4587.class_4665> railTransforms) {
            this.tracks.add(new TrackSegmentData(light, tieTransform, railTransforms));
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (TrackSegmentData track : this.tracks) {
                ((SuperByteBuffer)((SuperByteBuffer)this.tie.mulPose((Matrix4fc)track.tieTransform.method_23761())).mulNormal((Matrix3fc)track.tieTransform.method_23762())).light(track.light).renderInto(matricesEntry, vertexConsumer);
                for (boolean first : Iterate.trueAndFalse) {
                    class_4587.class_4665 transform = track.railTransforms.get(first);
                    ((SuperByteBuffer)((SuperByteBuffer)(first ? this.left : this.right).mulPose((Matrix4fc)transform.method_23761())).mulNormal((Matrix3fc)transform.method_23762())).light(track.light).renderInto(matricesEntry, vertexConsumer);
                }
            }
        }

        @Environment(value=EnvType.CLIENT)
        public record TrackSegmentData(int light, class_4587.class_4665 tieTransform, Couple<class_4587.class_4665> railTransforms) {
        }
    }
}

